> Taken from ChatGPT


---
Perfect — Ubuntu 24.04 makes things really smooth. Here’s a more tailored version for you:

___

## 🧰 How to Set Up Tailscale + Secure Tunnel on Ubuntu 24.04 VPS

### 1. ✅ **Install Tailscale on Your VPS**

SSH into your VPS and run:

```bash 
curl -fsSL https://tailscale.com/install.sh | sh
sudo tailscale up
```

This will:

-   Install Tailscale
    
-   Prompt you to sign in via a browser (you can copy the link and open it locally)
    

After that, your VPS is in your Tailscale network.

___

### 2. 🧑💻 **Install Tailscale on Your Local Machine**

Do the same on your personal computer:

-   Download Tailscale
    
-   Sign in with the same account
    
-   Run `tailscale up`
    

___

### 3. 🔎 **Find Your VPS Tailscale IP or Name**

After connecting both devices:

You’ll see something like:

```sql
vps-name       100.101.102.103   linux   idle
```

You can now SSH into your VPS like:

```bash
ssh username@100.101.102.103
# Or
ssh username@vps-name.tailnet-name.ts.net
```

___

### 4. 🛡️ **Lock Down Public SSH Access with UFW**

This is the key part for keeping it secure while using a VPN:

#### Enable UFW and set it up:

```bash
sudo ufw default deny incoming
sudo ufw default allow outgoing
```

#### Allow SSH **only** from Tailscale IP range:

```bash
sudo ufw allow from 100.64.0.0/10 to any port 22 proto tcp
```

> `100.64.0.0/10` is the range used by Tailscale devices.

#### Enable UFW:

```bash
sudo ufw enable
sudo ufw status
```

Your VPS now:

-   Rejects all public SSH access
    
-   Accepts SSH only from your Tailscale-connected devices
    
-   Doesn’t care if your IP changes via your main VPN
    

___

### 🧠 Pro Tips

-   Enable MagicDNS in the Tailscale admin panel for easier hostname-based access.
    
-   You can add ACLs and device tags if you want to control access to certain machines.