require 'fileutils'

# Set the directory path
dir_path = "./cleanup-tiff-posts/"

# Define a regex to match common date formats in filenames
date_pattern = /(\d{4}-\d{2}-\d{2})|(\d{2}-\d{2}-\d{4})/

# Loop through each file in the directory
Dir.foreach(dir_path) do |filename|
  next if filename == '.' || filename == '..'

  new_filename = filename.gsub(date_pattern, '').gsub('__', '_').strip
  new_path = File.join(dir_path, new_filename)

  # Rename the file if the name has changed
  if new_filename != filename
    FileUtils.mv(File.join(dir_path, filename), new_path)
    puts "Renamed: #{filename} -> #{new_filename}"
  end
end

puts "Date removal complete!"